'use strict';

/* --------------------------------------------------------------
 add_tracking_number.js 2016-09-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Add Tracking Number Modal Controller
 *
 * Handles the functionality of the "Add Tracking Number" modal.
 */
gx.controllers.module('add_tracking_number', ['modal', gx.source + '/libs/info_box'], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * Stores the tracking number for a specific order.
     *
     * @param {jQuery.Event} event
     */
    function _onStoreTrackingNumberClick(event) {
        event.preventDefault();

        var orderId = $this.data('orderId');
        var parcelServiceId = $('#delivery-service').find('option:selected').val();
        var trackingNumber = $('input:text[name="tracking-number"]').val();

        // Make an AJAX call to store the tracking number if one was provided.
        if (trackingNumber.length) {
            $.ajax({
                url: './admin.php?do=OrdersModalsAjax/StoreTrackingNumber',
                data: {
                    orderId: orderId,
                    trackingNumber: trackingNumber,
                    parcelServiceId: parcelServiceId,
                    pageToken: jse.core.config.get('pageToken')
                },
                method: 'POST',
                dataType: 'JSON'
            }).done(function (response) {
                $this.modal('hide');
                jse.libs.info_box.addSuccessMessage(jse.core.lang.translate('ADD_TRACKING_NUMBER_SUCCESS', 'admin_orders'));
                $('.table-main').DataTable().ajax.reload(null, false);
            }).fail(function (jqXHR, textStatus, errorThrown) {
                jse.libs.modal.message({
                    title: jse.core.lang.translate('error', 'messages'),
                    content: jse.core.lang.translate('ADD_TRACKING_NUMBER_ERROR', 'admin_orders')
                });
                jse.core.debug.error('Store Tracking Number Error', jqXHR, textStatus, errorThrown);
            });
        } else {
            // Show an error message
            var $modalFooter = $this.find('.modal-footer');
            var errorMessage = jse.core.lang.translate('TXT_SAVE_ERROR', 'admin_general');

            // Remove error message
            $modalFooter.find('span').remove();
            $modalFooter.prepend('<span class="text-danger">' + errorMessage + '</span>');
        }
    }

    /**
     * On Add Tracking Number Modal Hidden
     *
     * Reset the tracking number modal.
     */
    function _onAddTrackingNumberModalHidden() {
        $(this).find('#tracking-number').val('');
        $(this).find('.modal-footer span').remove();
    }

    /**
     * On Add Tracking Number Modal Show
     *
     * Handles the event for storing a a tracking number from the tracking number modal.
     *
     * @param {jQuery.Event} event
     */
    function _onAddTrackingNumberModalShow(event) {
        event.stopPropagation();
        // Element which invoked the tracking number modal.
        $(this).data('orderId', $(event.relatedTarget).data('orderId'));
    }

    /**
     * Checks if the enter key was pressed and delegates to
     * the tracking number store method.
     *
     * @param {jQuery.Event} event
     */
    function _saveOnPressedEnterKey(event) {
        var keyCode = event.keyCode ? event.keyCode : event.which;

        if (keyCode === 13) {
            _onStoreTrackingNumberClick(event);
        }
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('show.bs.modal', _onAddTrackingNumberModalShow).on('hidden.bs.modal', _onAddTrackingNumberModalHidden).on('click', '#store-tracking-number', _onStoreTrackingNumberClick).on('keypress', _saveOnPressedEnterKey);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
